/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.HscLockManager;
import java.util.Vector;

class HscGroupLock {
    HscLockManager _lkMgr;
    int _lockType;
    long _timeout;
    int count;
    int locked;
    int[] ostat;
    Vector lockObjs;

    private HscGroupLock(HscLockManager hscLockManager, int n, Vector vector, long l) {
        this._lkMgr = hscLockManager;
        this._lockType = n;
        this._timeout = l;
        this.count = vector.size();
        this.lockObjs = vector;
        this.ostat = new int[this.count];
        int n2 = 0;
        while (n2 < this.count) {
            this.ostat[n2] = 0;
            ++n2;
        }
    }

    static HscGroupLock genGLockObject(HscLockManager hscLockManager, int n, Vector vector, long l) throws HSCCIMException {
        if (hscLockManager == null || vector == null || vector.size() < 1 || n != 3 && n != 4) {
            throw new HSCCIMException("32" + "RWLOCK-01: Invalid lock type".substring(7, 8));
        }
        return new HscGroupLock(hscLockManager, n, vector, l);
    }

    int setGlock() throws HSCCIMException {
        int n = 0;
        while (n < this.count) {
            this.ostat[n] = this._lkMgr.getHscCecLock((String)this.lockObjs.get(n)).Lock(this._lockType, this._timeout);
            if (this.ostat[n] == 1) {
                ++this.locked;
            }
            ++n;
        }
        return this.locked;
    }

    int hasGroupLock() throws HSCCIMException {
        if (this.locked == this.count) {
            return 1;
        }
        int n = 0;
        while (n < this.count) {
            if (this.ostat[n] != 1) {
                this.ostat[n] = this._lkMgr.getHscCecLock((String)this.lockObjs.get(n)).getLockState(this._lockType);
                if (this.ostat[n] == 1) {
                    ++this.locked;
                }
            }
            ++n;
        }
        if (this.locked == this.count) {
            return 1;
        }
        return 2;
    }

    void unsetGlock() {
        try {
            int n = 0;
            while (n < this.count) {
                this._lkMgr.getHscCecLock((String)this.lockObjs.get(n)).Unlock();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(" UnLock grouplock exception: " + exception);
        }
    }
}

